import axios from 'axios'

export function getCurrentMonthStartDate () {
  const date = new Date()
  const firstDay = new Date(date.getFullYear(), date.getMonth(), 1)
  return firstDay.toISOString().substring(0, 10)
}

export function getTodaysDate () {
  const today = new Date()

  let dd = today.getDate()
  let mm = today.getMonth() + 1
  const yyyy = today.getFullYear()

  if (dd < 10) {
    dd = '0' + dd
  }

  if (mm < 10) {
    mm = '0' + mm
  }

  return `${yyyy}-${mm}-${dd}`
}

export function initAxios () {
  axios.defaults.headers.common.Authorization = process.env.TRACTION_API_KEY
  axios.defaults.headers.common['X-Slack-Signature'] = process.env.SLACK_SIGNING_SECRET
  axios.defaults.headers.common['X-API-KEY'] = process.env.TRACTION_API_KEY
}
