import { createRequire } from 'node:module'
import axios from 'axios'
const require = createRequire(import.meta.url)
const { App, AwsLambdaReceiver } = require('@slack/bolt')

// Initializes your app with your bot token and signing secret
// For when not running serverlsess
/* export const app = new Bolt.App({
  appToken: process.env.SLACK_APP_TOKEN,
  port: process.env.PORT || 3000,
  signingSecret: process.env.SLACK_SIGNING_SECRET,
  socketMode: process.env.SOCKET_MODE === 'true',
  token: process.env.SLACK_BOT_TOKEN
 }) */

export const awsLambdaReceiver = new AwsLambdaReceiver({
  signingSecret: process.env.SLACK_SIGNING_SECRET
})

// Initializes your app with your bot token and the AWS Lambda ready receiver
export const app = new App({
  token: process.env.SLACK_BOT_TOKEN,
  receiver: awsLambdaReceiver

  // When using the AwsLambdaReceiver, processBeforeResponse can be omitted.
  // If you use other Receivers, such as ExpressReceiver for OAuth flow support
  // then processBeforeResponse: true is required. This option will defer sending back
  // the acknowledgement until after your handler has run to ensure your function
  // isn't terminated early by responding to the HTTP request that triggered it.

  // processBeforeResponse: true
})

export async function getUsersEmail (client, userId) {
  const response = await client.users.info({
    user: userId
  })

  return response.user.profile.email
}

export function generateSuspiciousIpAlertResponse (suspiciousIpAddress) {
  return {
    blocks: [
      {
        type: 'section',
        text: {
          type: 'mrkdwn',
          text: ':alert: *SpamSlayer identified an IP address as* :sus: :red-sus:    :alert:\n\n' +
                            `Would You Like To Block The IP Address *${suspiciousIpAddress}*?` +
                            '\n\n_(A Click Report and Summary Report For This IP Will Be Posted In This Thread)_'
        }
      },
      {
        type: 'actions',
        elements: [
          {
            type: 'button',
            text: {
              type: 'plain_text',
              text: 'Take Action'
            },
            style: 'primary',
            value: `${suspiciousIpAddress}`,
            action_id: 'open_spam_slayer_modal'
          },
          {
            type: 'button',
            text: {
              type: 'plain_text',
              text: 'Don\'t Take Action'
            },
            style: 'danger',
            value: `${suspiciousIpAddress}`,
            action_id: 'dont_block_ip_address'
          }
        ]
      }
    ],
    text: {
      type: 'mrkdwn',
      text: ':alert: *SpamSlayer identified this IP address as :sus: :*\n\n' +
                    `${suspiciousIpAddress}`
    }
  }
}

export async function updateOriginalMessage (responseUrl, suspiciousIpAddress, message = null) {
  if (!message) {
    const origMsg = generateSuspiciousIpAlertResponse(suspiciousIpAddress).blocks
    message = {
      replace_original: true,
      blocks: [
        {
          type: 'section',
          text: {
            type: 'mrkdwn',
            text: '`There was an error processing your request, please try again`'
          }
        },
        origMsg[0],
        origMsg[1]
      ]
    }
  } else {
    message = {
      replace_original: true,
      text: message
    }
  }
  const response = axios.post(responseUrl, message, (error) => {
    console.log(error)
  }).catch((error) => {
    console.log(error)
  })

  return response
}

export function verifyChannelPermissions (slackChannel, say) {
  // Update to only clicksMonitoringChannel when officially rolled out
  // For when not using serverless and loading from .env
  // const allowedChannels = JSON.parse(process.env.ALLOWED_SLACK_CHANNELS)
  const allowedChannels = [process.env.CLICKS_MONITORING, process.env.HACKATHON_CHANNEL]

  if (!allowedChannels.includes(slackChannel)) {
    say('You dont have permission to block this ip')
    throw new Error('Unauthorized')
  }
}
