import axios from 'axios'
import * as constant from './constants.js'
import * as util from './util.js'

export async function blockIpAddresses (ipAddresses) {
  if (typeof ipAddresses === 'string') {
    ipAddresses = ipAddresses.split(',')
  }

  const data = { ipAddresses }

  return await axios.post(`${constant.tractionDomain}/ads/api/clicks/blockIpAddresses`, data)
}

export async function demonetizeClicks (data) {
  return await axios.post(`${constant.tractionDomain}/ads/api/clicks/demonetize`, data)
}

export async function getClicksReportFromTraction (suspiciousIpAddress, say, startDate = '', endDate = null) {
  let data = null
  if (startDate && !endDate) {
    endDate = util.getTodaysDate()
  }

  try {
    await axios.get(`${constant.tractionDomain}/ads/api/clicks/export?ipAddress=${suspiciousIpAddress}&startDate=${startDate}`,
      { responseType: 'text' })
      .then(response => {
        data = response.data
      })
  } catch (error) {
    await say(`\`Error getting clicks report from traction for IP Address ${suspiciousIpAddress}\` - *${error.response.status}: ${error.response.statusText}*`)
  }

  return data
}

export async function getClicksReportSummaryFromTraction (suspiciousIpAddress, say, startDate = '', endDate = null) {
  let data = null
  if (startDate && !endDate) {
    endDate = util.getTodaysDate()
  }

  try {
    await axios.get(`${constant.tractionDomain}/ads/api/clicks/export-summary?ipAddress=${suspiciousIpAddress}&startDate=${startDate}&endDate=${endDate}`,
      { responseType: 'text' })
      .then(response => {
        data = response.data
      })
  } catch (error) {
    await say(`\`Error getting clicks report summary from traction for IP Address ${suspiciousIpAddress}\` - *${error.response.status}: ${error.response.statusText}*`)
  }

  return data
}
