import tempWrite from 'temp-write'
import * as api from './functions/api.js'
import * as bolt from './functions/bolt.js'
import * as util from './functions/util.js'
import * as func from './functions/index.js'

util.initAxios()

bolt.app.action('dont_block_ip_address', async ({ ack, body, client, logger, say, respond }) => {
  await ack()
  const ipAddress = body.actions[0].value
  const msg = await func.updateBtnViewNoAction(ipAddress, body.user.id)
  await respond(msg)
})

bolt.app.action('open_spam_slayer_modal', async ({ payload, body, client, ack }) => {
  await ack()
  const suspiciousIpAddress = payload.value
  func.openSpamSlayerModal(suspiciousIpAddress, body, client)
})

bolt.app.message(func.isSpamSlayerAlertMessageMiddleware, async ({ message, say }) => {
  func.handleSpamSlayerAlertMessage(message, say)
})

bolt.app.view('spam_slayer_modal', async ({ ack, view, body }) => {
  let updatedReport = null

  const startDate = view.state.values['datepicker-block']['datepicker-action'].selected_date
  const blockIp = !!view.state.values['checkbox-block']['checkbox-action'].selected_options[0]?.value ?? false
  const errors = func.validateStartDate(startDate)

  const viewMetadata = JSON.parse(view.private_metadata)
  const responseUrl = viewMetadata.responseUrl
  const suspiciousIpAddress = viewMetadata.suspiciousIpAddress
  const thread = viewMetadata.thread
  const userEmail = viewMetadata.userEmail

  if (Object.keys(errors).length > 0) {
    return await ack({
      response_action: 'errors',
      errors
    })
  }

  await ack()

  await bolt.updateOriginalMessage(responseUrl, suspiciousIpAddress, `Processing Your Request  <@${viewMetadata.user}> `)

  // TODO update/create real error handling
  const apiErrors = []

  if (blockIp) {
    try {
      api.blockIpAddresses(suspiciousIpAddress)
      viewMetadata.blockIp = blockIp
    } catch (error) {
      apiErrors.traffic = error?.response?.data?.message
    }
  }
  try {
    const data = {
      ipAddress: suspiciousIpAddress,
      startDate,
      userEmail
    }

    api.demonetizeClicks(data)
      .then((response) => {
        updatedReport = response.data
        viewMetadata.startDate = startDate
        viewMetadata.apiErrors = apiErrors

        func.updateBtnViewBlockIp(viewMetadata).then(() => {
          const filePath = tempWrite.sync(updatedReport, 'clicks-report.csv')
          func.uploadClickReportToSlack(filePath, suspiciousIpAddress, thread, true)
        })
      })
  } catch (error) {
    console.log(error)
    bolt.updateOriginalMessage(responseUrl, suspiciousIpAddress)
  }
})

// Handle the Lambda function event
export const handler = async (event, context, callback) => {
  const handler = await bolt.awsLambdaReceiver.start()
  return handler(event, context, callback)
}

// If developing locally and with nodemon instead of serverless,
// uncomment the below block and comment out the handler block above
// You will also need to comment and uncomment code blocks in bolt.js
/*
(async () => {
  // Start your app
  await bolt.app.start()
  console.log('⚡️ Bolt app is running! on port ' + process.env.PORT)
})()
*/
