/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.testng.collections.Lists;
import org.testng.internal.collections.Pair;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;
import org.testng.xml.dom.Wrapper;

public class Reflect {
    public static List<Pair<Method, Wrapper>> findMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2, Object object) {
        List<Pair<Method, Wrapper>> list = Lists.newArrayList();
        for (Method method : clazz.getMethods()) {
            Annotation annotation = method.getAnnotation(clazz2);
            if (annotation == null) continue;
            list.add(Pair.of(method, new Wrapper(annotation, object)));
        }
        return list;
    }

    public static Pair<Method, Wrapper> findSetterForTag(Class<?> clazz, String string, Object object) {
        List<Class> list = Arrays.asList(OnElement.class, OnElementList.class, Tag.class);
        for (Class clazz2 : list) {
            List<Pair<Method, Wrapper>> list2 = Reflect.findMethodsWithAnnotation(clazz, clazz2, object);
            for (Method[] methodArray : list2) {
                if (!methodArray.second().getTagName().equals(string)) continue;
                return methodArray;
            }
        }
        for (String string2 : new String[]{"add", "set"}) {
            for (Method method : clazz.getDeclaredMethods()) {
                String string3 = Reflect.toCamelCase(string, string2);
                if (!method.getName().equals(string3)) continue;
                return Pair.of(method, null);
            }
        }
        return null;
    }

    private static String toCamelCase(String string, String string2) {
        return string2 + Reflect.toCapitalizedCamelCase(string);
    }

    public static String toCapitalizedCamelCase(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, 1).toUpperCase());
        for (int j = 1; j < string.length(); ++j) {
            if (string.charAt(j) == '-') {
                stringBuilder.append(Character.toUpperCase(string.charAt(j + 1)));
                ++j;
                continue;
            }
            stringBuilder.append(string.charAt(j));
        }
        return stringBuilder.toString();
    }
}

