/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.testng.IDataProviderListener;
import org.testng.IDataProviderMethod;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IParameterizable;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Test;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.DataProviderMethod;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.ParameterHolder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.annotations.IDataProvidable;
import org.testng.internal.collections.ArrayIterator;
import org.testng.internal.reflect.DataProviderMethodMatcher;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherContext;
import org.testng.internal.reflect.Parameter;
import org.testng.internal.reflect.ReflectionRecipes;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class Parameters {
    public static final String NULL_VALUE = "null";
    private static final Map<Class<? extends Annotation>, Class<? extends IAnnotation>> ANNOTATION_MAP = new ConcurrentHashMap<Class<? extends Annotation>, Class<? extends IAnnotation>>();
    private static Class<?>[] annotationList;
    private static Map<String, List<Class<?>>> mapping;
    private static final List<Class<?>> INJECTED_TYPES;

    public static Object[] createInstantiationParameters(Constructor constructor, String string, IAnnotationFinder iAnnotationFinder, String[] stringArray, Map<String, String> map, XmlSuite xmlSuite) {
        return Parameters.createParametersForConstructor(constructor, constructor.getParameterTypes(), iAnnotationFinder.findOptionalValues(constructor), string, stringArray, new MethodParameters(map, Collections.emptyMap()), xmlSuite);
    }

    public static Object[] createConfigurationParameters(Method method, Map<String, String> map, Object[] objectArray, @Nullable ITestNGMethod iTestNGMethod, IAnnotationFinder iAnnotationFinder, XmlSuite xmlSuite, ITestContext iTestContext, ITestResult iTestResult) {
        Method method2 = iTestNGMethod != null ? iTestNGMethod.getConstructorOrMethod().getMethod() : null;
        Map<String, String> map2 = iTestNGMethod != null ? iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest()) : Collections.emptyMap();
        Class<? extends Annotation> clazz = Parameters.retrieveConfigAnnotation(method);
        String string = clazz == null ? "" : clazz.getSimpleName();
        Class<? extends IAnnotation> clazz2 = null;
        if (clazz != null) {
            clazz2 = ANNOTATION_MAP.get(clazz);
        }
        return Parameters.createParameters(method, new MethodParameters(map, map2, objectArray, method2, iTestContext, iTestResult), iAnnotationFinder, xmlSuite, clazz2, string);
    }

    private static Class<? extends Annotation> retrieveConfigAnnotation(Method method) {
        for (Class<?> clazz : annotationList) {
            if (method.getAnnotation(clazz) == null) continue;
            return clazz;
        }
        return null;
    }

    @Deprecated
    public static Object getInjectedParameter(Class<?> clazz, Method method, ITestContext iTestContext, ITestResult iTestResult) {
        Object object = null;
        if (Method.class.equals(clazz)) {
            object = method;
        } else if (ITestContext.class.equals(clazz)) {
            object = iTestContext;
        } else if (XmlTest.class.equals(clazz)) {
            object = iTestContext.getCurrentXmlTest();
        } else if (ITestResult.class.equals(clazz)) {
            object = iTestResult;
        }
        return object;
    }

    private static Object[] createParametersForConstructor(Constructor constructor, Class<?>[] classArray, String[] stringArray, String string, String[] stringArray2, MethodParameters methodParameters, XmlSuite xmlSuite) {
        Object object;
        Object[] objectArray;
        if (classArray.length == 0) {
            return new Object[0];
        }
        Parameters.checkParameterTypes(constructor.getName(), classArray, string, stringArray2);
        List list = Lists.newArrayList();
        if (Parameters.canInject(string) && (objectArray = ReflectionRecipes.inject(object = ReflectionRecipes.getConstructorParameters(constructor), InjectableParameter.Assistant.ALL_INJECTS, new Object[0], constructor, methodParameters.context, methodParameters.testResult)) != null) {
            list.addAll(Arrays.asList(objectArray));
        }
        object = Parameters.createParams(constructor.getName(), "constructor", string, classArray, stringArray, stringArray2, methodParameters, xmlSuite);
        list.addAll(object);
        return list.toArray(new Object[list.size()]);
    }

    private static List<Object> createParams(String string, String string2, String string3, Class<?>[] classArray, String[] stringArray, String[] stringArray2, MethodParameters methodParameters, XmlSuite xmlSuite) {
        List<Object> list = Lists.newArrayList();
        if (stringArray.length != stringArray2.length) {
            FilterOutInJectedTypesResult filterOutInJectedTypesResult = Parameters.filterOutInJectedTypesFromOptionalValues(classArray, stringArray);
            stringArray = filterOutInJectedTypesResult.getOptionalValues();
            classArray = filterOutInJectedTypesResult.getParameterTypes();
        }
        for (int j = 0; j < stringArray2.length; ++j) {
            String string4 = stringArray2[j];
            String string5 = (String)methodParameters.xmlParameters.get(string4);
            if (null == string5) {
                string5 = System.getProperty(string4);
            }
            if (null == string5) {
                if (stringArray != null) {
                    string5 = stringArray[j];
                }
                if (null == string5) {
                    throw new TestNGException("Parameter '" + string4 + "' is required by " + string3 + " on " + string2 + " " + string + " but has not been marked @Optional or defined\n" + (xmlSuite.getFileName() != null ? "in " + xmlSuite.getFileName() : ""));
                }
            }
            list.add(Parameters.convertType(classArray[j], string5, string4));
        }
        return list;
    }

    static FilterOutInJectedTypesResult filterOutInJectedTypesFromOptionalValues(Class<?>[] classArray, String[] stringArray) {
        List<Class<?>> list = Lists.newArrayList(classArray);
        List<String> list2 = Lists.newArrayList(stringArray);
        Iterator<Class<?>> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            iterator2.next();
            if (!INJECTED_TYPES.contains(clazz)) continue;
            iterator2.remove();
            iterator.remove();
        }
        return new FilterOutInJectedTypesResult(list.toArray(new Class[list.size()]), list2.toArray(new String[list2.size()]));
    }

    private static Object[] createParametersForMethod(Method method, Class<?>[] classArray, String[] stringArray, String string, String[] stringArray2, MethodParameters methodParameters, XmlSuite xmlSuite) {
        if (classArray.length == 0) {
            return new Object[0];
        }
        Parameters.checkParameterTypes(method.getName(), classArray, string, stringArray2);
        List list = Lists.newArrayList();
        List<Object> list2 = Parameters.createParams(method.getName(), "method", string, classArray, stringArray, stringArray2, methodParameters, xmlSuite);
        if (Parameters.canInject(string)) {
            Parameter[] parameterArray = ReflectionRecipes.getMethodParameters(method);
            Object[] objectArray = ReflectionRecipes.inject(parameterArray, InjectableParameter.Assistant.ALL_INJECTS, list2.toArray(new Object[list2.size()]), methodParameters.currentTestMethod, methodParameters.context, methodParameters.testResult);
            if (objectArray != null) {
                list.addAll(Arrays.asList(objectArray));
            }
        } else {
            list.addAll(list2);
        }
        return list.toArray(new Object[list.size()]);
    }

    private static boolean canInject(String string) {
        return !("@" + Test.class.getSimpleName()).equalsIgnoreCase(string);
    }

    private static void checkParameterTypes(String string, Class<?>[] classArray, String string2, String[] stringArray) {
        int n = classArray.length;
        for (Class<?> clazz : classArray) {
            if (!INJECTED_TYPES.contains(clazz)) continue;
            --n;
        }
        if (stringArray.length == 0) {
            boolean bl;
            boolean bl2 = bl = n != 0 || !Parameters.validParameters(string2, classArray);
            if (bl) {
                String string3 = string2;
                if (!string2.startsWith("@")) {
                    string3 = "@" + string2;
                }
                String string4 = mapping.containsKey(string2) ? "Can inject only one of " + Parameters.prettyFormat(mapping.get(string2)) + " into a " + string3 + " annotated " + string : "Cannot inject " + string3 + " annotated Method [" + string + "] with " + Arrays.toString(classArray);
                throw new TestNGException(string4 + ".\nFor more information on native dependency injection please refer to http://testng.org/doc/documentation-main.html#native-dependency-injection");
            }
        }
        if (stringArray.length != n) {
            throw new TestNGException("Method " + string + " requires " + classArray.length + " parameters but " + stringArray.length + " were supplied in the " + string2 + " annotation.");
        }
    }

    private static boolean validParameters(String string, Class[] classArray) {
        List<Class<?>> list = mapping.get(string.replace("@", ""));
        if (list == null) {
            return false;
        }
        for (Class clazz : classArray) {
            if (list.contains(clazz)) continue;
            return false;
        }
        return true;
    }

    private static String prettyFormat(List<Class<?>> list) {
        StringBuilder stringBuilder = new StringBuilder("<");
        if (list.size() == 1) {
            stringBuilder.append(list.get(0));
        } else {
            int n = list.size();
            for (int j = 0; j < n - 1; ++j) {
                stringBuilder.append(list.get(j).getSimpleName()).append(", ");
            }
            stringBuilder.append(list.get(n - 1).getSimpleName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public static <T> T convertType(Class<T> clazz, String string, String string2) {
        try {
            if (string == null || NULL_VALUE.equals(string.toLowerCase())) {
                if (clazz.isPrimitive()) {
                    Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + string2 + "'");
                }
                return null;
            }
            if (clazz == String.class) {
                return (T)string;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (T)Integer.valueOf(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (T)Byte.valueOf(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return (T)Double.valueOf(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return (T)Float.valueOf(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return (T)Long.valueOf(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (T)Short.valueOf(string);
            }
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, string);
            }
        }
        catch (Exception exception) {
            throw new TestNGException("Conversion issue on parameter: " + string2, exception);
        }
        throw new TestNGException("Unsupported type parameter : " + clazz);
    }

    private static IDataProviderMethod findDataProvider(Object object, ITestClass iTestClass, ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder, ITestContext iTestContext) {
        IDataProviderMethod iDataProviderMethod = null;
        IDataProvidable iDataProvidable = Parameters.findDataProviderInfo(iTestClass, constructorOrMethod, iAnnotationFinder);
        if (iDataProvidable != null) {
            String string = iDataProvidable.getDataProvider();
            Class<?> clazz = iDataProvidable.getDataProviderClass();
            if (!Utils.isStringEmpty(string) && null == (iDataProviderMethod = Parameters.findDataProvider(object, iTestClass, iAnnotationFinder, string, clazz, iTestContext))) {
                throw new TestNGException("Method " + constructorOrMethod + " requires a @DataProvider named : " + string + (clazz != null ? " in class " + clazz.getName() : ""));
            }
        }
        return iDataProviderMethod;
    }

    private static IDataProvidable findDataProviderInfo(ITestClass iTestClass, ConstructorOrMethod constructorOrMethod, IAnnotationFinder iAnnotationFinder) {
        IDataProvidable iDataProvidable;
        if (constructorOrMethod.getMethod() != null) {
            iDataProvidable = AnnotationHelper.findTest(iAnnotationFinder, constructorOrMethod.getMethod());
            if (iDataProvidable == null) {
                iDataProvidable = AnnotationHelper.findFactory(iAnnotationFinder, constructorOrMethod.getMethod());
            }
            if (iDataProvidable == null) {
                iDataProvidable = AnnotationHelper.findTest(iAnnotationFinder, iTestClass.getRealClass());
            }
        } else {
            iDataProvidable = AnnotationHelper.findFactory(iAnnotationFinder, constructorOrMethod.getConstructor());
        }
        return iDataProvidable;
    }

    private static IDataProviderMethod findDataProvider(Object object, ITestClass iTestClass, IAnnotationFinder iAnnotationFinder, String string, Class<?> clazz, ITestContext iTestContext) {
        DataProviderMethod dataProviderMethod = null;
        Class<?> clazz2 = iTestClass.getRealClass();
        boolean bl = false;
        if (clazz != null) {
            clazz2 = clazz;
            bl = true;
        }
        for (Method method : ClassHelper.getAvailableMethods(clazz2)) {
            Injector injector;
            IDataProviderAnnotation iDataProviderAnnotation = iAnnotationFinder.findAnnotation(method, IDataProviderAnnotation.class);
            if (null == iDataProviderAnnotation || !string.equals(Parameters.getDataProviderName(iDataProviderAnnotation, method))) continue;
            Object object2 = bl && (method.getModifiers() & 8) == 0 ? ((injector = iTestContext.getInjector(iTestClass)) != null ? injector.getInstance(clazz) : ClassHelper.newInstance(clazz)) : object;
            if ((method.getModifiers() & 8) == 0 && object2 == null) {
                object2 = ClassHelper.newInstanceOrNull(clazz2);
            }
            if (dataProviderMethod != null) {
                throw new TestNGException("Found two providers called '" + string + "' on " + clazz2);
            }
            dataProviderMethod = new DataProviderMethod(object2, method, iDataProviderAnnotation);
        }
        return dataProviderMethod;
    }

    private static String getDataProviderName(IDataProviderAnnotation iDataProviderAnnotation, Method method) {
        return Strings.isNullOrEmpty(iDataProviderAnnotation.getName()) ? method.getName() : iDataProviderAnnotation.getName();
    }

    private static Object[] createParameters(Method method, MethodParameters methodParameters, IAnnotationFinder iAnnotationFinder, XmlSuite xmlSuite, Class clazz, String string) {
        Object[] objectArray;
        Object object;
        List list = Lists.newArrayList();
        IParametersAnnotation iParametersAnnotation = iAnnotationFinder.findAnnotation(method, IParametersAnnotation.class);
        Class<?>[] classArray = method.getParameterTypes();
        if (null != iParametersAnnotation) {
            object = iParametersAnnotation.getValue();
            objectArray = Parameters.createParametersForMethod(method, classArray, iAnnotationFinder.findOptionalValues(method), string, (String[])object, methodParameters, xmlSuite);
        } else {
            object = (IParameterizable)iAnnotationFinder.findAnnotation(method, clazz);
            if (null != object && object.getParameters() != null && object.getParameters().length > 0) {
                String[] stringArray = object.getParameters();
                objectArray = Parameters.createParametersForMethod(method, classArray, iAnnotationFinder.findOptionalValues(method), string, stringArray, methodParameters, xmlSuite);
            } else {
                objectArray = Parameters.createParametersForMethod(method, classArray, iAnnotationFinder.findOptionalValues(method), string, new String[0], methodParameters, xmlSuite);
            }
        }
        Collections.addAll(list, objectArray);
        for (int j = 0; j < classArray.length; ++j) {
            if (!Object[].class.equals(classArray[j])) continue;
            list.add(j, methodParameters.parameterValues);
        }
        return list.toArray(new Object[list.size()]);
    }

    public static ParameterHolder handleParameters(ITestNGMethod iTestNGMethod, Map<String, String> map, Object object, MethodParameters methodParameters, XmlSuite xmlSuite, IAnnotationFinder iAnnotationFinder, Object object2) {
        return Parameters.handleParameters(iTestNGMethod, map, object, methodParameters, xmlSuite, iAnnotationFinder, object2, Collections.emptyList());
    }

    public static ParameterHolder handleParameters(final ITestNGMethod iTestNGMethod, Map<String, String> map, Object object, MethodParameters methodParameters, XmlSuite xmlSuite, IAnnotationFinder iAnnotationFinder, Object object2, Collection<IDataProviderListener> collection) {
        final IDataProviderMethod iDataProviderMethod = Parameters.findDataProvider(object, iTestNGMethod.getTestClass(), iTestNGMethod.getConstructorOrMethod(), iAnnotationFinder, methodParameters.context);
        if (null != iDataProviderMethod) {
            int n = iTestNGMethod.getConstructorOrMethod().getParameterTypes().length;
            for (int j = 0; j < n; ++j) {
                String object42 = "param" + j;
                map.put(object42, object42);
            }
            for (IDataProviderListener iDataProviderListener : collection) {
                iDataProviderListener.beforeDataProviderExecution(iDataProviderMethod, iTestNGMethod, methodParameters.context);
            }
            final Iterator<IDataProviderListener> iterator = MethodInvocationHelper.invokeDataProvider(iDataProviderMethod.getInstance(), iDataProviderMethod.getMethod(), iTestNGMethod, methodParameters.context, object2, iAnnotationFinder);
            for (IDataProviderListener iDataProviderListener : collection) {
                iDataProviderListener.afterDataProviderExecution(iDataProviderMethod, iTestNGMethod, methodParameters.context);
            }
            final ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.addAll(iTestNGMethod.getInvocationNumbers());
            arrayList.addAll(iDataProviderMethod.getIndices());
            final Iterator<Object[]> iterator2 = new Iterator<Object[]>(){
                int index = 0;
                boolean hasWarn = false;

                @Override
                public boolean hasNext() {
                    if (this.index == 0 && !iterator.hasNext() && !this.hasWarn) {
                        this.hasWarn = true;
                        Utils.log("", 2, "Warning: the data provider '" + iDataProviderMethod.getName() + "' returned an empty array or iterator, so this test is not doing anything");
                    }
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    iTestNGMethod.setParameterInvocationCount(this.index);
                    Object[] objectArray = (Object[])iterator.next();
                    if (!arrayList.isEmpty() && !arrayList.contains(this.index)) {
                        objectArray = null;
                    }
                    ++this.index;
                    return objectArray;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
            iTestNGMethod.setMoreInvocationChecker(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return iterator2.hasNext();
                }
            });
            return new ParameterHolder(iterator2, ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER, iDataProviderMethod);
        }
        map.putAll(methodParameters.xmlParameters);
        Object[][] objectArray = new Object[][]{Parameters.createParameters(iTestNGMethod.getConstructorOrMethod().getMethod(), methodParameters, iAnnotationFinder, xmlSuite, ITestAnnotation.class, "@Test")};
        iTestNGMethod.setParameterInvocationCount(objectArray.length);
        ArrayIterator arrayIterator = new ArrayIterator(objectArray);
        return new ParameterHolder(arrayIterator, ParameterHolder.ParameterOrigin.ORIGIN_XML, null);
    }

    public static Object[] injectParameters(Object[] objectArray, Method method, ITestContext iTestContext) throws TestNGException {
        MethodMatcherContext methodMatcherContext = new MethodMatcherContext(method, objectArray, iTestContext, null);
        DataProviderMethodMatcher dataProviderMethodMatcher = new DataProviderMethodMatcher(methodMatcherContext);
        return dataProviderMethodMatcher.getConformingArguments();
    }

    public static Object[] getParametersFromIndex(Iterator<Object[]> iterator, int n) {
        while (iterator.hasNext()) {
            Object[] objectArray = iterator.next();
            if (n == 0) {
                return objectArray;
            }
            --n;
        }
        return null;
    }

    static {
        ANNOTATION_MAP.put(BeforeSuite.class, IBeforeSuite.class);
        ANNOTATION_MAP.put(AfterSuite.class, IAfterSuite.class);
        ANNOTATION_MAP.put(BeforeTest.class, IBeforeTest.class);
        ANNOTATION_MAP.put(AfterTest.class, IAfterTest.class);
        ANNOTATION_MAP.put(BeforeClass.class, IBeforeClass.class);
        ANNOTATION_MAP.put(AfterClass.class, IAfterClass.class);
        ANNOTATION_MAP.put(BeforeGroups.class, IBeforeGroups.class);
        ANNOTATION_MAP.put(AfterGroups.class, IAfterGroups.class);
        ANNOTATION_MAP.put(BeforeMethod.class, IBeforeMethod.class);
        ANNOTATION_MAP.put(AfterMethod.class, IAfterMethod.class);
        annotationList = new Class[]{BeforeSuite.class, AfterSuite.class, BeforeTest.class, AfterTest.class, BeforeClass.class, AfterClass.class, BeforeGroups.class, AfterGroups.class, BeforeMethod.class, AfterMethod.class};
        mapping = Maps.newHashMap();
        List<Class> list = Arrays.asList(ITestContext.class, XmlTest.class);
        List<Class> list2 = Arrays.asList(ITestContext.class, XmlTest.class, Method.class, Object[].class, ITestResult.class);
        mapping.put(BeforeSuite.class.getSimpleName(), list);
        mapping.put(AfterSuite.class.getSimpleName(), list);
        mapping.put(BeforeTest.class.getSimpleName(), list);
        mapping.put(AfterTest.class.getSimpleName(), list);
        mapping.put(BeforeGroups.class.getSimpleName(), list);
        mapping.put(AfterGroups.class.getSimpleName(), list);
        mapping.put(BeforeClass.class.getSimpleName(), list);
        mapping.put(AfterClass.class.getSimpleName(), list);
        mapping.put(BeforeMethod.class.getSimpleName(), list2);
        mapping.put(AfterMethod.class.getSimpleName(), list2);
        mapping.put(Test.class.getSimpleName(), Collections.singletonList(ITestContext.class));
        INJECTED_TYPES = Arrays.asList(ITestContext.class, ITestResult.class, XmlTest.class, Method.class, Object[].class);
    }

    public static class MethodParameters {
        private final Map<String, String> xmlParameters;
        private final Method currentTestMethod;
        private final ITestContext context;
        private Object[] parameterValues;
        public ITestResult testResult;

        public MethodParameters(Map<String, String> map, Map<String, String> map2) {
            this(map, map2, null, null, null, null);
        }

        public static MethodParameters newInstance(Map<String, String> map, ITestNGMethod iTestNGMethod, ITestContext iTestContext) {
            Map<String, String> map2 = iTestNGMethod.findMethodParameters(iTestContext.getCurrentXmlTest());
            Object[] objectArray = null;
            ITestResult iTestResult = null;
            Method method = iTestNGMethod.getConstructorOrMethod().getMethod();
            return new MethodParameters(map, map2, objectArray, method, iTestContext, iTestResult);
        }

        public MethodParameters(Map<String, String> map, Map<String, String> map2, Object[] objectArray, Method method, ITestContext iTestContext, ITestResult iTestResult) {
            Map<String, String> map3 = Maps.newHashMap();
            map3.putAll(map);
            map3.putAll(map2);
            this.xmlParameters = map3;
            this.currentTestMethod = method;
            this.context = iTestContext;
            this.parameterValues = objectArray;
            this.testResult = iTestResult;
        }
    }

    static final class FilterOutInJectedTypesResult {
        private Class<?>[] parameterTypes;
        private String[] optionalValues;

        private FilterOutInJectedTypesResult(Class<?>[] classArray, String[] stringArray) {
            this.parameterTypes = classArray;
            this.optionalValues = stringArray;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        String[] getOptionalValues() {
            return this.optionalValues;
        }
    }
}

