/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.testng.collections.Lists;
import org.testng.internal.Utils;

public class PackageUtils {
    private static final String UTF_8 = "UTF-8";
    private static final String PACKAGE_UTILS = PackageUtils.class.getSimpleName();
    private static String[] testClassPaths;
    private static final Collection<ClassLoader> classLoaders;

    private PackageUtils() {
    }

    public static void addClassLoader(ClassLoader classLoader) {
        classLoaders.add(classLoader);
    }

    public static String[] findClassesInPackage(String string, List<String> list, List<String> list2) throws IOException {
        Class[] classArray;
        Object object;
        String string2 = string;
        boolean bl = false;
        if (string.endsWith(".*")) {
            string2 = string.substring(0, string.lastIndexOf(".*"));
            bl = true;
        }
        List<String> list3 = Lists.newArrayList();
        String string3 = string2.replace('.', '/') + (string2.length() > 0 ? "/" : "");
        List<Object> list4 = Lists.newArrayList();
        List<Object> list5 = Lists.newArrayList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            list5.add(classLoader);
        }
        list5.addAll(classLoaders);
        for (Object object2 : list5) {
            if (null == object2) continue;
            object = ((ClassLoader)object2).getResources(string3);
            while (object.hasMoreElements()) {
                classArray = (URL)object.nextElement();
                list4.add(classArray);
            }
        }
        for (Object object2 : list4) {
            Object object3;
            Object object4;
            Object object5;
            object = ((URL)object2).getProtocol();
            if (!PackageUtils.matchTestClasspath((URL)object2, string3, bl)) continue;
            if ("file".equals(object)) {
                PackageUtils.findClassesInDirPackage(string2, list, list2, URLDecoder.decode(((URL)object2).getFile(), UTF_8), bl, list3);
                continue;
            }
            if ("jar".equals(object)) {
                classArray = ((JarURLConnection)((URL)object2).openConnection()).getJarFile();
                object5 = classArray.entries();
                while (object5.hasMoreElements()) {
                    object4 = (JarEntry)object5.nextElement();
                    object3 = ((ZipEntry)object4).getName();
                    if (((String)object3).charAt(0) == '/') {
                        object3 = ((String)object3).substring(1);
                    }
                    if (!((String)object3).startsWith(string3)) continue;
                    int n = ((String)object3).lastIndexOf(47);
                    if (n != -1) {
                        string = ((String)object3).substring(0, n).replace('/', '.');
                    }
                    if (!bl && !string.equals(string2)) continue;
                    Utils.log(PACKAGE_UTILS, 4, "Package name is " + string);
                    if (!((String)object3).endsWith(".class") || ((ZipEntry)object4).isDirectory()) continue;
                    String string4 = ((String)object3).substring(string.length() + 1, ((String)object3).length() - 6);
                    Utils.log(PACKAGE_UTILS, 4, "Found class " + string4 + ", seeing it if it's included or excluded");
                    PackageUtils.includeOrExcludeClass(string, string4, list, list2, list3);
                }
                continue;
            }
            if (!"bundleresource".equals(object)) continue;
            try {
                classArray = new Class[]{};
                object5 = ((URL)object2).openConnection();
                object4 = ((URL)object2).openConnection().getClass().getDeclaredMethod("getFileURL", classArray);
                object3 = new Object[]{};
                URL uRL = (URL)((Method)object4).invoke(object5, (Object[])object3);
                PackageUtils.findClassesInDirPackage(string2, list, list2, URLDecoder.decode(uRL.getFile(), UTF_8), bl, list3);
            }
            catch (Exception exception) {
            }
        }
        return list3.toArray(new String[list3.size()]);
    }

    private static String[] getTestClasspath() {
        if (null != testClassPaths) {
            return testClassPaths;
        }
        String string = System.getProperty("testng.test.classpath");
        if (null == string) {
            return null;
        }
        String[] stringArray = Utils.split(string, File.pathSeparator);
        testClassPaths = new String[stringArray.length];
        for (int j = 0; j < stringArray.length; ++j) {
            String string2 = stringArray[j].toLowerCase().endsWith(".jar") || stringArray[j].toLowerCase().endsWith(".zip") ? stringArray[j] + "!/" : (stringArray[j].endsWith(File.separator) ? stringArray[j] : stringArray[j] + "/");
            PackageUtils.testClassPaths[j] = string2.replace('\\', '/');
        }
        return testClassPaths;
    }

    private static boolean matchTestClasspath(URL uRL, String string, boolean bl) {
        String[] stringArray = PackageUtils.getTestClasspath();
        if (null == stringArray) {
            return true;
        }
        String string2 = "";
        try {
            string2 = URLDecoder.decode(uRL.getFile(), UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (String string3 : stringArray) {
            String string4 = string3 + string;
            int n = string2.indexOf(string4);
            if (n == -1 || n > 0 && string2.charAt(n - 1) != '/' || !string2.endsWith(string3 + string) && (!bl || string2.charAt(n + string4.length()) != '/')) continue;
            return true;
        }
        return false;
    }

    private static void findClassesInDirPackage(String string, List<String> list, List<String> list2, String string2, final boolean bl, List<String> list3) {
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return bl && file.isDirectory() || file.getName().endsWith(".class") || file.getName().endsWith(".groovy");
            }
        });
        Utils.log(PACKAGE_UTILS, 4, "Looking for test classes in the directory: " + file);
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                PackageUtils.findClassesInDirPackage(PackageUtils.makeFullClassName(string, file2.getName()), list, list2, file2.getAbsolutePath(), bl, list3);
                continue;
            }
            String string3 = file2.getName().substring(0, file2.getName().lastIndexOf(46));
            Utils.log(PACKAGE_UTILS, 4, "Found class " + string3 + ", seeing it if it's included or excluded");
            PackageUtils.includeOrExcludeClass(string, string3, list, list2, list3);
        }
    }

    private static String makeFullClassName(String string, String string2) {
        return string.length() > 0 ? string + "." + string2 : string2;
    }

    private static void includeOrExcludeClass(String string, String string2, List<String> list, List<String> list2, List<String> list3) {
        if (PackageUtils.isIncluded(string, list, list2)) {
            Utils.log(PACKAGE_UTILS, 4, "... Including class " + string2);
            list3.add(PackageUtils.makeFullClassName(string, string2));
        } else {
            Utils.log(PACKAGE_UTILS, 4, "... Excluding class " + string2);
        }
    }

    private static boolean isIncluded(String string, List<String> list, List<String> list2) {
        boolean bl;
        if (list.isEmpty() && list2.isEmpty()) {
            bl = true;
        } else {
            boolean bl2 = PackageUtils.find(string, list);
            boolean bl3 = PackageUtils.find(string, list2);
            bl = bl2 && !bl3 ? true : (bl3 ? false : list.isEmpty());
        }
        return bl;
    }

    private static boolean find(String string, List<String> list) {
        for (String string2 : list) {
            if (!Pattern.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    static {
        classLoaders = new ConcurrentLinkedDeque<ClassLoader>();
    }
}

