/*
 * Decompiled with CFR 0.152.
 */
package org.testng.collections;

import java.util.List;
import org.testng.collections.Lists;
import org.testng.util.Strings;

public final class Objects {
    private Objects() {
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static class ToStringHelper {
        private String m_className;
        private List<ValueHolder> values = Lists.newArrayList();
        private boolean m_omitNulls = false;
        private boolean m_omitEmptyStrings = false;

        public ToStringHelper(String string) {
            this.m_className = string;
        }

        public ToStringHelper omitNulls() {
            this.m_omitNulls = true;
            return this;
        }

        public ToStringHelper omitEmptyStrings() {
            this.m_omitEmptyStrings = true;
            return this;
        }

        public ToStringHelper add(String string, String string2) {
            this.values.add(new ValueHolder(string, this.s(string2)));
            return this;
        }

        public ToStringHelper add(String string, Object object) {
            this.values.add(new ValueHolder(string, this.s(object)));
            return this;
        }

        private String s(Object object) {
            return object != null ? (object.toString().isEmpty() ? "\"\"" : object.toString()) : "{null}";
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[" + this.m_className + " ");
            for (int j = 0; j < this.values.size(); ++j) {
                ValueHolder valueHolder = this.values.get(j);
                if (this.m_omitNulls && valueHolder.isNull() || this.m_omitEmptyStrings && valueHolder.isEmptyString()) continue;
                if (j > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(valueHolder.toString());
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private static class ValueHolder {
        private String m_name;
        private String m_value;

        public ValueHolder(String string, String string2) {
            this.m_name = string;
            this.m_value = string2;
        }

        boolean isNull() {
            return this.m_value == null;
        }

        public String toString() {
            return this.m_name + "=" + this.m_value;
        }

        public boolean isEmptyString() {
            return Strings.isNullOrEmpty(this.m_value);
        }
    }
}

