/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources.comparators;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedResourceComparator
extends ResourceComparator {
    private List<ResourceComparator> resourceComparators = null;

    public synchronized void add(ResourceComparator c) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (c == null) {
            return;
        }
        this.resourceComparators = this.resourceComparators == null ? new Vector() : this.resourceComparators;
        this.resourceComparators.add(c);
        this.setChecked(false);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.isReference()) {
            return this.getCheckedRef().equals(o);
        }
        if (!(o instanceof DelegatedResourceComparator)) {
            return false;
        }
        List<ResourceComparator> ov = ((DelegatedResourceComparator)o).resourceComparators;
        return this.resourceComparators == null ? ov == null : this.resourceComparators.equals(ov);
    }

    @Override
    public synchronized int hashCode() {
        if (this.isReference()) {
            return this.getCheckedRef().hashCode();
        }
        return this.resourceComparators == null ? 0 : this.resourceComparators.hashCode();
    }

    @Override
    protected synchronized int resourceCompare(Resource foo, Resource bar) {
        if (this.resourceComparators == null || this.resourceComparators.isEmpty()) {
            return foo.compareTo(bar);
        }
        int result = 0;
        Iterator<ResourceComparator> i2 = this.resourceComparators.iterator();
        while (result == 0 && i2.hasNext()) {
            result = i2.next().resourceCompare(foo, bar);
        }
        return result;
    }

    @Override
    protected void dieOnCircularReference(Stack<Object> stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            if (this.resourceComparators != null && !this.resourceComparators.isEmpty()) {
                for (ResourceComparator resourceComparator : this.resourceComparators) {
                    if (!(resourceComparator instanceof DataType)) continue;
                    DelegatedResourceComparator.pushAndInvokeCircularReferenceCheck(resourceComparator, stk, p);
                }
            }
            this.setChecked(true);
        }
    }
}

