/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogWriter;
import org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import org.apache.tools.ant.taskdefs.cvslib.CvsVersion;
import org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class ChangeLogTask
extends AbstractCvsTask {
    private File usersFile;
    private Vector cvsUsers = new Vector();
    private File inputDir;
    private File destFile;
    private Date startDate;
    private Date endDate;
    private boolean remote = false;
    private String startTag;
    private String endTag;
    private final Vector filesets = new Vector();

    public void setDir(File inputDir) {
        this.inputDir = inputDir;
    }

    public void setDestfile(File destFile) {
        this.destFile = destFile;
    }

    public void setUsersfile(File usersFile) {
        this.usersFile = usersFile;
    }

    public void addUser(CvsUser user) {
        this.cvsUsers.addElement(user);
    }

    public void setStart(Date start) {
        this.startDate = start;
    }

    public void setEnd(Date endDate) {
        this.endDate = endDate;
    }

    public void setDaysinpast(int days) {
        long time = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(time));
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public void setStartTag(String start) {
        this.startTag = start;
    }

    public void setEndTag(String end) {
        this.endTag = end;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File savedDir = this.inputDir;
        try {
            this.validate();
            Properties userList = new Properties();
            this.loadUserlist(userList);
            int size = this.cvsUsers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                CvsUser user = (CvsUser)this.cvsUsers.get(i2);
                user.validate();
                userList.put(user.getUserID(), user.getDisplayname());
            }
            if (!this.remote) {
                this.setCommand("log");
                if (this.getTag() != null) {
                    CvsVersion myCvsVersion = new CvsVersion();
                    myCvsVersion.setProject(this.getProject());
                    myCvsVersion.setTaskName("cvsversion");
                    myCvsVersion.setCvsRoot(this.getCvsRoot());
                    myCvsVersion.setCvsRsh(this.getCvsRsh());
                    myCvsVersion.setPassfile(this.getPassFile());
                    myCvsVersion.setDest(this.inputDir);
                    myCvsVersion.execute();
                    if (myCvsVersion.supportsCvsLogWithSOption()) {
                        this.addCommandArgument("-S");
                    }
                }
            } else {
                this.setCommand("");
                this.addCommandArgument("rlog");
                this.addCommandArgument("-S");
                this.addCommandArgument("-N");
            }
            if (null != this.startTag || null != this.endTag) {
                String startValue = this.startTag == null ? "" : this.startTag;
                String endValue = this.endTag == null ? "" : this.endTag;
                this.addCommandArgument("-r" + startValue + "::" + endValue);
            } else if (null != this.startDate) {
                SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
                String dateRange = ">=" + outputDate.format(this.startDate);
                this.addCommandArgument("-d");
                this.addCommandArgument(dateRange);
            }
            if (!this.filesets.isEmpty()) {
                Enumeration e = this.filesets.elements();
                while (e.hasMoreElements()) {
                    FileSet fileSet = (FileSet)e.nextElement();
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    String[] files = scanner.getIncludedFiles();
                    for (int i3 = 0; i3 < files.length; ++i3) {
                        this.addCommandArgument(files[i3]);
                    }
                }
            }
            ChangeLogParser parser = new ChangeLogParser(this.remote, this.getPackage(), this.getModules());
            RedirectingStreamHandler handler = new RedirectingStreamHandler(parser);
            this.log(this.getCommand(), 3);
            this.setDest(this.inputDir);
            this.setExecuteStreamHandler(handler);
            try {
                super.execute();
            }
            finally {
                String errors = handler.getErrors();
                if (null != errors) {
                    this.log(errors, 0);
                }
            }
            CVSEntry[] entrySet = parser.getEntrySetAsArray();
            CVSEntry[] filteredEntrySet = this.filterEntrySet(entrySet);
            this.replaceAuthorIdWithName(userList, filteredEntrySet);
            this.writeChangeLog(filteredEntrySet);
        }
        finally {
            this.inputDir = savedDir;
        }
    }

    private void validate() throws BuildException {
        if (null == this.inputDir) {
            this.inputDir = this.getProject().getBaseDir();
        }
        if (null == this.destFile) {
            String message = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.inputDir.exists()) {
            String message = "Cannot find base dir " + this.inputDir.getAbsolutePath();
            throw new BuildException(message);
        }
        if (null != this.usersFile && !this.usersFile.exists()) {
            String message = "Cannot find user lookup list " + this.usersFile.getAbsolutePath();
            throw new BuildException(message);
        }
        if (!(null == this.startTag && null == this.endTag || null == this.startDate && null == this.endDate)) {
            String message = "Specify either a tag or date range, not both";
            throw new BuildException("Specify either a tag or date range, not both");
        }
    }

    private void loadUserlist(Properties userList) throws BuildException {
        if (null != this.usersFile) {
            try {
                userList.load(new FileInputStream(this.usersFile));
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
    }

    private CVSEntry[] filterEntrySet(CVSEntry[] entrySet) {
        Vector<CVSEntry> results = new Vector<CVSEntry>();
        for (int i2 = 0; i2 < entrySet.length; ++i2) {
            CVSEntry cvsEntry = entrySet[i2];
            Date date = cvsEntry.getDate();
            if (null == date || null != this.startDate && this.startDate.after(date) || null != this.endDate && this.endDate.before(date)) continue;
            results.addElement(cvsEntry);
        }
        Object[] resultArray = new CVSEntry[results.size()];
        results.copyInto(resultArray);
        return resultArray;
    }

    private void replaceAuthorIdWithName(Properties userList, CVSEntry[] entrySet) {
        for (int i2 = 0; i2 < entrySet.length; ++i2) {
            CVSEntry entry = entrySet[i2];
            if (!userList.containsKey(entry.getAuthor())) continue;
            entry.setAuthor(userList.getProperty(entry.getAuthor()));
        }
    }

    /*
     * Loose catch block
     */
    private void writeChangeLog(CVSEntry[] entrySet) throws BuildException {
        FileOutputStream output;
        block6: {
            output = null;
            try {
                output = new FileOutputStream(this.destFile);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
                ChangeLogWriter serializer = new ChangeLogWriter();
                serializer.printChangeLog(writer, entrySet);
                if (!writer.checkError()) break block6;
                throw new IOException("Encountered an error writing changelog");
            }
            catch (UnsupportedEncodingException uee) {
                this.getProject().log(uee.toString(), 0);
                FileUtils.close(output);
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
                {
                    catch (Throwable throwable) {
                        FileUtils.close(output);
                        throw throwable;
                    }
                }
            }
        }
        FileUtils.close(output);
    }
}

